#include "csg_structure.h"
#include "Meter_MCU.h"
#include "AFE_Communication.h"
#include "HOST_Communication.h"

/////////////////////pc communication packet///////////////////////////////
/* Incoming serial message buffer */
serial_msg_t rx_msg;
unsigned char rx_msg_len;
unsigned char rx_msg_ptr;

/* Outgoing serial message buffer */
serial_msg_t tx_msg;
unsigned char tx_msg_len;
unsigned char tx_msg_ptr;

unsigned int *next_flash_loc;


////////////////////////////////////////////////////////////////////
/////////////////////PC communication, use USCI/////////////////////
////////////////////////////////////////////////////////////////////
int send_msg(int len)
{
    if (len > 4 + 12 + MAX_IEC1107_MSG_BODY)
        return FALSE;
    tx_msg_ptr = 0;
    tx_msg_len = len;

    for(char i = 0; i < len; i++){
      UCA0TXBUF = tx_msg.uint8[i];
      while(!(IFG2&UCA0TXIFG));
    }
    return  TRUE;
}

int prepare_tx_message(int len)
{
    int i;

    tx_msg.uint8[0] = 0xFE;
    tx_msg.uint8[1] = 0xFE;
    tx_msg.uint8[2] = 0xFE;
    tx_msg.uint8[3] = 0xFE;
    tx_msg.uint8[4] = 0x68;
    tx_msg.uint8[5] = 0x99;
    tx_msg.uint8[6] = 0x99;
    tx_msg.uint8[7] = 0x99;
    tx_msg.uint8[8] = 0x99;
    tx_msg.uint8[9] = 0x99;
    tx_msg.uint8[10] = 0x99;
    tx_msg.uint8[11] = 0x68;
    tx_msg.uint8[12] = 0x23;
    tx_msg.uint8[13] = len;
    tx_msg.uint8[IEC1107_MSG_TX_START_BODY + len] = 0;
    tx_msg.uint8[IEC1107_MSG_TX_START_BODY + len + 1] = 0x16;
    for (i = 4;  i < IEC1107_MSG_TX_START_BODY + len;  i++)
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + len] += tx_msg.uint8[i];
    return send_msg(IEC1107_MSG_TX_START_BODY + len + 2);
}

void process_rx_message(serial_msg_t *rx_msg, int rx_len)
{
    /* Messages with type 0x23 are custom messages we
      use for calibration, password protection, etc.
      All other message types go to a custom message
      handler (if available). */
    if (rx_msg->uint8[8] != 0x23)
    {
#ifdef CUSTOM_SERIAL_MESSAGE_SUPPORT
        custom_serial_message_handler(&rx_msg, rx_msg_len);
#endif
        return;
    }
    if ((rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] & 0x80))
    {
        /* This looks like one of our own messages, which has echoed back
           to us */
        return;
    }

    /* Only process messages if the password has been given correctly
       (except for the password test message, of course). */
//    if (!(meter_status & PASSWORD_OK)  &&  rx_msg->uint8[IEC1107_MSG_RX_START_BODY] != 0x60)
//        return;

    switch (rx_msg->uint8[IEC1107_MSG_RX_START_BODY])
    {
    case HOST_CMD_GET_READINGS_PHASE_1:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        gFlag &= ~FL_AFE_READING_OUT_CH;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] == 0x07)
          gFlag |= FL_AFE_READING_OUT_EN;
        else
          gFlag &= ~FL_AFE_READING_OUT_EN;

        prepare_tx_message(2);        
        break;
    case HOST_CMD_GET_READINGS_NEUTRAL:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        
        gFlag |= FL_AFE_READING_OUT_CH;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] == 0x07)
          gFlag |= FL_AFE_READING_OUT_EN;
        else
          gFlag &= ~FL_AFE_READING_OUT_EN;
    
        prepare_tx_message(2);        
        break;

    case HOST_CMD_GET_RAW_POWER_PHASE_1:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 1] = 0;
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 2] = 0;
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 3] = 0;
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 4] = 0;
        prepare_tx_message(10);
        break;
    case HOST_CMD_GET_RAW_REACTIVE_POWER_PHASE_1:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 1] = 0;//phase->current.P_reactive_accum_logged[0][0];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 2] = 0;//phase->current.P_reactive_accum_logged[0][1];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 3] = 0;//phase->current.P_reactive_accum_logged[0][2];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 4] = 0;//phase->sample_count_logged;
        prepare_tx_message(10);
        break;
    case HOST_CMD_GET_RAW_POWER_NEUTRAL:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 1] = 0;//phase->neutral.P_accum_logged[0][0];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 2] = 0;//phase->neutral.P_accum_logged[0][1];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 3] = 0;//phase->neutral.P_accum_logged[0][2];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 4] = 0;//phase->sample_count_logged;
        prepare_tx_message(10);
        break;
    case HOST_CMD_GET_RAW_REACTIVE_POWER_NEUTRAL:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 1] = 0;//phase->neutral.P_reactive_accum_logged[0][0];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 2] = 0;//phase->neutral.P_reactive_accum_logged[0][1];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 3] = 0;//phase->neutral.P_reactive_accum_logged[0][2];
        tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 4] = 0;//phase->sample_count_logged;
        prepare_tx_message(10);
        break;
        
//////Percy for Calibration 0902////////////////////////////////        
    case HOST_CMD_CALIBRATION_GET_GAIN:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        
        gFlag |= FL_HST_READ_AFE_CAL;
        break;                         
    case HOST_CMD_CALIBRATION_GET_CONF:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;

        gFlag |= FL_HST_READ_AFE_CONF;           
        break;  
    case HOST_CMD_CALIBRATION_SET_GAIN:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY+2] == 0)//live
          prepare_afe_write(AFE_CMD_SET_METER_P1_GAIN, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        else
          prepare_afe_write(AFE_CMD_SET_METER_P2_GAIN, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        prepare_tx_message(2);
        break;          
    case HOST_CMD_CALIBRATION_SET_PHASE:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY+2] == 0)//live
          prepare_afe_write(AFE_CMD_SET_METER_P1_PHASE, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        else
          prepare_afe_write(AFE_CMD_SET_METER_P2_PHASE, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);        
        prepare_tx_message(2);
        break;          
    case HOST_CMD_CALIBRATION_SET_IRMS_GAIN:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY+2] == 0)//live
          prepare_afe_write(AFE_CMD_SET_METER_I1RMS_GAIN, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        else
          prepare_afe_write(AFE_CMD_SET_METER_I2RMS_GAIN, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        prepare_tx_message(2);
        break;  
    case HOST_CMD_CALIBRATION_SET_VRMS_GAIN:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_METER_VRMS_GAIN, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        prepare_tx_message(2);
        break;         
    case HOST_CMD_CALIBRATION_SET_POFFSET:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY+2] == 0)//live
          prepare_afe_write(AFE_CMD_SET_METER_P1_OFFSET, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        else
          prepare_afe_write(AFE_CMD_SET_METER_P2_OFFSET, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);                
        prepare_tx_message(2);
        break;   
    case HOST_CMD_CALIBRATION_SET_QOFFSET:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY+2] == 0)//live
          prepare_afe_write(AFE_CMD_SET_METER_Q1_OFFSET, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        else
          prepare_afe_write(AFE_CMD_SET_METER_Q2_OFFSET, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);                
        prepare_tx_message(2);
        break;         
    case HOST_CMD_CALIBRATION_SET_IRMS_OFFSET:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        if(rx_msg->uint8[IEC1107_MSG_RX_START_BODY+2] == 0)//live
          prepare_afe_write(AFE_CMD_SET_METER_I1RMS_OFFSET, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);
        else
          prepare_afe_write(AFE_CMD_SET_METER_I2RMS_OFFSET, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+2], 5);                
        prepare_tx_message(2);
        break;  
        
    case HOST_CMD_CONFIG_SET_SYSCONF:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_METER_SYSCONF, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+1], 5);                
        prepare_tx_message(2);
        break;  
    case HOST_CMD_CONFIG_SET_CSGCONF:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_METER_CSGCONF, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+1], 5);                
        prepare_tx_message(2);
        break;  
    case HOST_CMD_CONFIG_SET_PCONST:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_METER_POWER_CONST, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+1], 5);                
        prepare_tx_message(2);
        break;  
    case HOST_CMD_CONFIG_SET_STARTCUR:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_METER_START_CURRENT, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+1], 5);                
        prepare_tx_message(2);
        break;  
    case HOST_CMD_CONFIG_SET_IE:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_IE, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+1], 5);                
        prepare_tx_message(2);
        break;  
    case HOST_CMD_CONFIG_SET_WREN:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_WREN, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+1], 5);                
        prepare_tx_message(2);
        break;          
    case HOST_CMD_CONFIG_SET_SRST:
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY + 1] | 0x80;
        prepare_afe_write(AFE_CMD_SET_SRST, rx_msg->uint16[IEC1107_MSG_RX_START_BODY_W+1], 5);                
        prepare_tx_message(2);
        break;
        
    default:
        /* For all other message types reply with type 0xFF - bad message type */
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = rx_msg->uint8[IEC1107_MSG_RX_START_BODY];
        tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = 0xFF;
        prepare_tx_message(2);
        break;
    }
}

void send_calibration_data()
{
  tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = HOST_CMD_CALIBRATION_GET_GAIN;
  tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = 0x87;
        
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 1] = phase_nv->current[0].Ac_offset;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 2] = phase_nv->current[1].Ac_offset;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 3] = phase_nv->current[0].I_rms_scale_factor[0];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 4] = phase_nv->current[1].I_rms_scale_factor[0];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 5] = phase_nv->current[0].P_scale_factor[0];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 6] = phase_nv->current[1].P_scale_factor[0];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 7] = phase_nv->current[0].Phase_correction[0];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 8] = phase_nv->current[1].Phase_correction[0];          
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 7] = phase_nv->current[0].Phase_correction[0];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 9] = phase_nv->current[0].Offset_active_power;               
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 10] = neutral_nv->Offset_active_power;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 11] = phase_nv->current[0].Offset_reactive_power;               
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 12] = neutral_nv->Offset_reactive_power;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 13] = phase_nv->V_rms_scale_factor;               
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 14] = meter1.chksum1;               
  tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 30] = 0;

  prepare_tx_message(31);  
}

void send_config_data()
{
  tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = HOST_CMD_CALIBRATION_GET_CONF;
  tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = 0x87;
        
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 1] = phase_conf->gSysconf;       
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 2] = phase_conf->gCsgconf;       
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 3] = phase_conf->gPower_const;     
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 4] = phase_conf->gStart_curr;    
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 5] = meter1.int_enable;    
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 6] = meter1.status;    
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 7] = meter1.wren;    
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 8] = meter1.meter_status;    
     
  prepare_tx_message(18);     
}

void send_AFE_reading(unsigned char ch)
{
  if( ch == 1 )
    tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = HOST_CMD_GET_READINGS_PHASE_1+3;
  else
    tx_msg.uint8[IEC1107_MSG_TX_START_BODY] = HOST_CMD_GET_READINGS_PHASE_1;
  tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 1] = 0x87;

  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 1] = phase->V_rms;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 2] = phase->I_rms[ch];    
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 3] = phase->active_power[ch];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 4] = phase->active_power[ch] >> 16;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 5] = phase->reactive_power[ch];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 6] = phase->reactive_power[ch] >> 16;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 7] = phase->apparent_power[ch];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 8] = phase->apparent_power[ch] >> 16;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 9] = phase->power_factor[ch];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 10] = phase->frequency;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 11] = phase->V_dc_estimate;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 12] = phase->V_dc_estimate>>16;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 13] = phase->I_dc_estimate[ch];
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 14] = phase->I_dc_estimate[ch]>>16;
  tx_msg.uint16[IEC1107_MSG_TX_START_BODY_W + 15] = 0;//meter1.chksum2;
  tx_msg.uint8[IEC1107_MSG_TX_START_BODY + 32] = 0;
  prepare_tx_message(33);
}